
SIGMA=1;
SEGMENT=1;
METHODWHOLE="Li"; // Used with SUM projection for whole NMJ segmentation
METHODHIGHVAR="Moments"; //Used with StdDev projection to segment high variance pixels
METHODMODVAR="Percentile";
REGIONS=newArray("Whole", "HighVar", "ModVar", "LowVar");
REGION=2; // region to measure. 0=whole NMJ, 1=high variance pixels, 2=low variance pixels
IMAGEEXT=".tif";
path=getDirectory("Pick a folder");
if(roiManager("count")>0)
	roiManager("Reset");
fl=getFileList(path);
setBatchMode(true);

for(i=0; i<fl.length; i++)
	{
	if(endsWith(fl[i], IMAGEEXT)==true)
		{
		open(path+""+fl[i]);
		run("Subtract Background...", "rolling=50 dark stack");
		run("Gaussian Blur...", "sigma=0.75 stack");
		getDimensions(width, height, channels, slices, frames);
		
		run("Z Project...", "start=1 projection=[Sum Slices]"); //For whole NMJ
		rename("WHOLE");
		setAutoThreshold(METHODWHOLE+" dark stack");
		run("Convert to Mask", "method="+METHODWHOLE+" background=Dark black");
		run("Select All");
		roiManager("Add"); // Roi 0=whole NMJ
		
		selectImage(fl[i]);
		run("Z Project...", "start=1 projection=[Standard Deviation]");  //For dynamic pixels
		rename("HIGHVAR");
		roiManager("Select", 0); // Calculate threshold only for presynaptic region
		setAutoThreshold(METHODHIGHVAR+" dark stack");
		run("Convert to Mask", "method="+METHODHIGHVAR+" background=Dark black");
		run("Create Selection");
		roiManager("Add");  // Roi 1=high var (highest ~20%

		selectImage(fl[i]);
		run("Z Project...", "start=1 projection=[Standard Deviation]");  //For dynamic pixels
		rename("MODVAR");
		roiManager("Select", 0); // Calculate threshold only for presynaptic region
		setAutoThreshold(METHODMODVAR+" dark stack");
		run("Convert to Mask", "method="+METHODMODVAR+" background=Dark black");
		run("Create Selection");
		roiManager("Add");  // Roi 2=moderate var (Highest ~ 50%)

		
		roiManager("Select", newArray(0,2)); 
		roiManager("XOR"); 
		roiManager("Add");  // Roi 3= low var (lowest ~50% of stdDev values)
		roiManager("save", path+"\\WHOLE-HI-LO_"+fl[i]+".zip");
		
		selectWindow(fl[i]);
		
		for(r=0; r<REGIONS.length; r++)
			{
			tablename=fl[i]+"_"+REGIONS[r]+"_Series";
			eval("js", "rt=new ResultsTable(); rt.setNaNEmptyCells(true); rt.show('"+tablename+"');");
			roiManager("Select", r);	
			Roi.getContainedPoints(xpoints, ypoints);
			
			for(f=0; f<slices; f++)
				{
				Stack.setSlice(f+1);
				pix=getPixValues(xpoints, ypoints);
				for(n=0; n<xpoints.length; n++)
					{
					Table.set("("+xpoints[n]+";"+ypoints[n]+")", f, pix[n], tablename);
					}
				}
			Table.save(path+"\\"+REGIONS[r]+"_pix_"+stripX(fl[i])+".csv");
			}
		close("*");
		roiManager("Reset");
		}
	}	

		


function PCC(X,Y)
	{
	Array.getStatistics(X, Xmin, Xmax, Xmean, XstdDev);
	Array.getStatistics(Y, Ymin, Ymax, Ymean, YstdDev);

	xy=0; xsq=0; ysq=0;
	for(i=0; i<X.length; i++)
		{
		x=X[i]-Xmean;
		y=Y[i]-Ymean;
		xy+=(x*y);
		xsq+=(x*x);
		ysq+=(y*y);
		
		}

	pearson=(xy/sqrt(xsq*ysq));
	return pearson;
	}

function getPixValues(xpoints, ypoints)
	{
	vals=newArray(xpoints.length);
	for(i=0; i<xpoints.length; i++)
		vals[i]=getPixel(xpoints[i], ypoints[i]);
	return vals;
	}

function stripX(string)
	{
	// This is because Macro language doesn't have a general use name without extension
	return substring(string, 0, lastIndexOf(string, "."));
	}
	
function segment(imp)
	{
	run("Duplicate...", "title=mask duplicate channels="+SEGMENT); //mask for whole cell
	run("Gaussian Blur...", "sigma="+SIGMA+" stack");
	setAutoThreshold(METHOD+" dark stack");
	run("Convert to Mask", "method="+METHOD+" background=Dark black");
	//run("Fill Holes");
	}